#!/bin/bash

# Install_OpFor_Support.sh - Revision v1 by Rafael "R4to0" Maciel
echo "Valve Opposing Force Single Player support for Sven Co-op"
echo "Based on original OpFor batch file by SC Team"
echo ""
echo "Warning: This script and ripent needs to be in svencoop"
echo "folder or will not work!"
echo ""
echo "Note: OpFor support requires around 70MB of free disk space"
echo "and needs to be installed using the steamcmd.sh"
echo ""
echo "(./steamcmd.sh +logon anonymous +force_install_dir .. +app_update 90 validate +quit)"
echo "(./steamcmd.sh +logon anonymous +force_install_dir .. +app_set_config 90 mod gearbox +app_update "90 -beta beta" validate +quit)"
echo ""

# Continue option
read -n1 -p "Continue? [y/N]: "
[[ [Yy] =~ $REPLY ]] || exit 0
echo ""
echo ""

# Variables
RIPENT=./ripent-linux-m32

check_dependencies () {
	echo "Checking for dependencies..."
	echo ""
	if [ ! -f $RIPENT ]
		then
			echo "Ripent for linux is missing."
			echo "Make sure you have ripent for linux in svencoop directory."
			echo ""
			echo "This script is now exiting."
			exit 1
	else
		echo "Ripent found."
		chmod +x $RIPENT
		echo ""
	fi
	command -v unzip >/dev/null 2>&1  || { 
			echo "Unzip is not installed."
			echo "You can install using 'apt-get install unzip"
			echo "on Ubuntu and Debian, and 'yum install unzip'"
			echo "on Redhat or CentOS."
			exit 1
	}
	echo "Unzip found."
	echo ""
}

copy_op4spmaps () {
	echo "Copying OP4SP maps from gearbox/maps"
	echo "folder to svencoop/maps folder."
	echo "May take a while, please wait..."
	cp ../gearbox/maps/of0*.bsp maps/
	cp ../gearbox/maps/of1*.bsp maps/

	cp ../gearbox/maps/of2a1.bsp maps/
	cp ../gearbox/maps/of2a1b.bsp maps/
	cp ../gearbox/maps/of2a4.bsp maps/
	cp ../gearbox/maps/of2a5.bsp maps/
	cp ../gearbox/maps/of2a6.bsp maps/

	cp ../gearbox/maps/of3*.bsp maps/
	rm maps/of3a1b.bsp
	cp ../gearbox/maps/of4*.bsp maps/
	cp ../gearbox/maps/of5*.bsp maps/
	cp ../gearbox/maps/of6*.bsp maps/
	#cp ../gearbox/maps/of7*.bsp maps/ #this one was commented in original bat, why?
	echo "Done!"
	echo ""
}

run_ripent() {
	echo "Unzipping ent files..."
	unzip -o opfor_support.sven -d maps > /dev/null
	echo "Applying ripent..."
		for op4sp in maps/of0*.bsp maps/of1*.bsp maps/of2*.bsp maps/of3*.bsp maps/of4*.bsp maps/of5*.bsp maps/of6*.bsp
		do
		$RIPENT -import $op4sp > /dev/null
		done
}

rem_entfiles (){
	echo "Removing ent files"
	rm maps/of0*.ent
	rm maps/of1*.ent
	rm maps/of2*.ent
	rm maps/of3*.ent
	rm maps/of4*.ent
	rm maps/of5*.ent
	rm maps/of6*.ent
	echo ""
}

runall () {
# dependencies checking
	check_dependencies
# copy maps from gearbox folder
	copy_op4spmaps
# apply ent files
	run_ripent
#remove ent files
	rem_entfiles
}

# SHIT, WE'VE GOT HOSTILES!
runall

echo "All done!"
echo "OP4SP Support installed sucessfully!"
echo ""
echo "This script is now exiting."
sleep 3
exit 0
